#import "ShrinkURL.h"

@implementation ShrinkURL

// TinyURL engine guts
- (NSString *) shrinkURL:(NSString *)input
{
    NSURL *url = [NSURL URLWithString:[NSString stringWithFormat:@"http://tinyurl.com/api-create.php?url=%@", input]];
    NSData *data = [url resourceDataUsingCache:YES];
    
    NSString *result = [[NSString alloc] initWithData:data encoding:NSASCIIStringEncoding];
    
    return result;
}

// Translate URL in place (standard service)
- (void)tinyURLTranslate:(NSPasteboard *)pboard
 userData:(NSString *)data
 error:(NSString **)error
 {

    NSString *pboardString;
    NSString *newString;
    NSArray *types;

    types = [pboard types];

    if (![types containsObject:NSStringPboardType] || !(pboardString = [pboard stringForType:NSStringPboardType])) {
        *error = NSLocalizedString(@"Error: Pasteboard doesn't contain a string.",
                   @"Pasteboard couldn't give string.");
        return;
    }


    newString = [self shrinkURL:pboardString];

    if (!newString) {
        *error = NSLocalizedString(@"Error: Couldn't shrink URL %@.",
                   @"Couldn't perform service operation.");
        return;
    }

    types = [NSArray arrayWithObject:NSStringPboardType];
    [pboard declareTypes:types owner:nil];
    [pboard setString:newString forType:NSStringPboardType];

    return;
}

// Translate URL onto clipboard (read-only service)
- (void)tinyURLTranslateToClipboard:(NSPasteboard *)pboard
 userData:(NSString *)data
 error:(NSString **)error
 {

    NSString *pboardString;
    NSString *newString;
    NSArray *types;

    types = [pboard types];

    if (![types containsObject:NSStringPboardType] || !(pboardString = [pboard stringForType:NSStringPboardType])) {
        *error = NSLocalizedString(@"Error: Pasteboard doesn't contain a string.",
                   @"Pasteboard couldn't give string.");
        return;
    }


    newString = [self shrinkURL:pboardString];

    if (!newString) {
        *error = NSLocalizedString(@"Error: Couldn't shrink URL %@.",
                   @"Couldn't perform service operation.");
        return;
    }
    
    NSPasteboard *destPaste = [NSPasteboard generalPasteboard];
    [destPaste declareTypes:[NSArray arrayWithObject:NSStringPboardType] owner:nil];
    [destPaste setString:newString forType:NSStringPboardType];    

    return;
}

// Translate URL in place *and* copy to clipboard
// (this will work with 10.4.x Mail.app, which annoyingly breaks service behaviors).
- (void)tinyURLTranslateDupeClipboard:(NSPasteboard *)pboard
 userData:(NSString *)data
 error:(NSString **)error
 {

    NSString *pboardString;
    NSString *newString;
    NSArray *types;

    types = [pboard types];

    if (![types containsObject:NSStringPboardType] || !(pboardString = [pboard stringForType:NSStringPboardType])) {
        *error = NSLocalizedString(@"Error: Pasteboard doesn't contain a string.",
                   @"Pasteboard couldn't give string.");
        return;
    }


    newString = [self shrinkURL:pboardString];

    if (!newString) {
        *error = NSLocalizedString(@"Error: Couldn't shrink URL %@.",
                   @"Couldn't perform service operation.");
        return;
    }
    
    NSPasteboard *destPaste = [NSPasteboard generalPasteboard];
    [destPaste declareTypes:[NSArray arrayWithObject:NSStringPboardType] owner:nil];
    [destPaste setString:newString forType:NSStringPboardType];    

    types = [NSArray arrayWithObject:NSStringPboardType];
    [pboard declareTypes:types owner:nil];
    [pboard setString:newString forType:NSStringPboardType];

    return;
}


@end
